
package demothrift;

import java.io.UnsupportedEncodingException;
import java.util.List;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class Main {

    public static final String UTF8 = "UTF8";

    public static void main(String[] args) throws UnsupportedEncodingException,
            InvalidRequestException, UnavailableException, TimedOutException,
            TException, NotFoundException {
        TTransport tr = new TSocket("localhost", 9160);
        TProtocol proto = new TBinaryProtocol(tr);
        Cassandra.Client client = new Cassandra.Client(proto);
        tr.open();

        String keyspace = "Keyspace1";
        String columnFamily = "Standard2";
        String keyUserID = "fredthrift";

        // Insérer les données
        long timestamp = System.currentTimeMillis();

        ColumnPath cp = new ColumnPath(columnFamily);
        cp.setColumn("Nom".getBytes(UTF8));

        client.insert(keyspace, keyUserID, cp, "Mazue".getBytes(UTF8), timestamp, ConsistencyLevel.ONE);

        ColumnPath cpa = new ColumnPath(columnFamily);
        cpa.setColumn("Age".getBytes(UTF8));

        client.insert(keyspace, keyUserID, cpa, "48".getBytes(UTF8),
                timestamp, ConsistencyLevel.ONE);

        // Lire les données
        //D'abord le nom
        Column col = client.get(keyspace, keyUserID, cp,
                ConsistencyLevel.ONE).getColumn();

        System.out.print(new String(col.name, UTF8) + ": ");
        System.out.println(new String(col.value, UTF8));
        // Ensuite l'âge
        col = client.get(keyspace, keyUserID, cpa,
        ConsistencyLevel.ONE).getColumn();

        System.out.print(new String(col.name, UTF8) + ": ");
        System.out.println(new String(col.value, UTF8));

        // Lire un enregistement entier
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]);
        sliceRange.setFinish(new byte[0]);
        predicate.setSlice_range(sliceRange);

        System.out.println("Contenu d'une ligne:");
        ColumnParent parent = new ColumnParent(columnFamily);
        List<ColumnOrSuperColumn> results = client.get_slice(keyspace,
                keyUserID, parent, predicate, ConsistencyLevel.ONE);
        for (ColumnOrSuperColumn result : results) {
            Column column = result.column;
            System.out.println(new String(column.name, UTF8) + " -> " + new String(column.value, UTF8));
        }
        tr.close();
    }
}
