package me.prettyprint.cassandra.service;

import static me.prettyprint.cassandra.utils.StringUtils.bytes;
import static me.prettyprint.cassandra.utils.StringUtils.string;


import static org.mockito.Mockito.mock;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class DemoHector {

    private CassandraClient client;
    private Keyspace keyspace;
    private CassandraClientPool pools;
    private CassandraClientMonitor monitor;

    public void setup() throws TTransportException, TException, IllegalArgumentException, NotFoundException, UnknownHostException {
        pools = mock(CassandraClientPool.class);
        monitor = mock(CassandraClientMonitor.class);
        client = new CassandraClientFactory(pools, new CassandraHost("localhost", 9160), monitor).create();
        keyspace = client.getKeyspace("Keyspace1", ConsistencyLevel.ONE, CassandraClient.DEFAULT_FAILOVER_POLICY);
    }


    public void demoColonne() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, NotFoundException, Exception {
        // Insérer les données
        ColumnPath cp = new ColumnPath("Standard1");
        cp.setColumn(bytes("Prenom"));
        keyspace.insert("fred", cp, bytes("Frederic"));
        cp.setColumn(bytes("Nom"));
        keyspace.insert("fred", cp, bytes("Mazue"));

        // lire les données
        // D'abord le prénom
        cp.setColumn(bytes("Prenom"));
        Column col = keyspace.getColumn("fred", cp);
        String value = string(col.getValue());
        System.out.println(value);
        // Ensuite le nom
        cp.setColumn(bytes("Nom"));
        col = keyspace.getColumn("fred", cp);
        value = string(col.getValue());
        System.out.println(value);

    }

    public void demoSuperColonne() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, NotFoundException, Exception {
        // Insérer les données
        ColumnPath cp = new ColumnPath("Super1");
        cp.setColumn(bytes("Prenom"));
        cp.setSuper_column(bytes("Auteur"));
        keyspace.insert("superfred", cp, bytes("Frederic"));
        cp.setColumn(bytes("Nom"));
        keyspace.insert("superfred", cp, bytes("Mazue"));
        cp.setSuper_column(bytes("Article"));
        cp.setColumn(bytes("Titre"));
        keyspace.insert("superfred", cp, bytes("Decouvrez Cassandra"));
        
        // Lire les données
        // D'abord celles relatives à l'auteur
        cp = new ColumnPath("Super1");
        cp.setSuper_column(bytes("Auteur"));
        SuperColumn sc = keyspace.getSuperColumn("superfred", cp);
        int n = sc.getColumns().size();
        System.out.println("Il y a " + n + " colonnes dans la colonne Auteur");
        Column col; 
        String name;
        String value;
        for(int i=0; i<n; i++)
        {     
            col = sc.getColumns().get(i);
            name = string(col.getName());
            value = string(col.getValue());
            System.out.println(name + " " + value);
        }
        // puis les données relatives à l'article
        cp.setSuper_column(bytes("Article"));
        sc = keyspace.getSuperColumn("superfred", cp);
        System.out.println("Il y a " + sc.getColumns().size() + " colonne dans la colonne Article");
        col = sc.getColumns().get(0);
        value = string(col.getValue());
        System.out.println("Titre article: " + value);

    }

    public static void main(String[] args) throws NotFoundException, Exception {
        DemoHector dh = new DemoHector();
        dh.setup();
        dh.demoColonne();
        dh.demoSuperColonne();
    }
}