#include <stdio.h>

#include <cuda.h>


void init()
{
	// Initialiser CUDA
	CUresult result = cuInit(0);
	switch(result)
	{
	case CUDA_SUCCESS:
		puts("Librairie CUDA initialisee correctement");
		break;
	case CUDA_ERROR_INVALID_VALUE:
	case CUDA_ERROR_NO_DEVICE:
	default:
		puts("Une erreur s'est produite  l'initialisation de CUDA");
		exit(1);
	}
}


__global__ void printGrid()
{	
	#ifdef __DEVICE_EMULATION__
		printf("Block: %d, %d, %d -- Thread: %d %d %d\n", 
			blockIdx.x,
			blockIdx.y,
			blockIdx.z,
			threadIdx.x,
			threadIdx.y,
			threadIdx.z);
	#endif
}

void run()
{
	dim3 dimBlock(2, 2, 2);
	dim3 dimGrid(2, 2, 1);
	
	printGrid<<<dimGrid, dimBlock>>>();	
}



int main(int argc, char** argv)
{	
	puts("Cuda DemoBlock -- Programmez!");
	
	init();
	run();
	
	return 0;
}
