#include <stdio.h>

#include <cuda.h>
#include <vector_types.h>

// et aussi nb de vecteurs
const int nb_threads = 3; 

void init()
{
	// Initialiser CUDA
	CUresult result = cuInit(0);
	switch(result)
	{
	case CUDA_SUCCESS:
		puts("Librairie CUDA initialisee correctement");
		break;
	case CUDA_ERROR_INVALID_VALUE:
	case CUDA_ERROR_NO_DEVICE:
	default:
		puts("Une erreur s'est produite  l'initialisation de CUDA");
		exit(1);
	}
}

/*
	Eventuellement mettre le comportement en vidence 
	en compilant avec l'option -deviceemu
*/
__global__ void compute(int3 *v)
{
	int id = threadIdx.x;
	/*
	// Mauvais code	
	if(id == 0)
	{
		__syncthreads(); //  Mauvais code, avec ou sans __syncthread
		v[id].x = v[1].x*2 + v[2].x*3;
		v[id].y = v[1].y*2 + v[2].y*3;
		v[id].z = v[1].z*2 + v[2].z*3;
	}
	else
	{
		for(int i=0; i<50000; i++)
			for(int i=0; i<1000; i++);
		v[id].x = id+1;
		v[id].y = id+1;
		v[id].z = id+1;
	}
	// fin mauvais code
	*/
	
	
	
	// Bon code
	v[id].x = id+1;
	v[id].y = id+1;
	v[id].z = id+1;
	
	if(id!=0)
	{
		for(int i=0; i<50000; i++)
			for(int i=0; i<1000; i++);
	}
	
	
	// Sans l'appel  syncthreads, le code
	// ne se comporte pas correctement
	__syncthreads();
	
	if(id == 0)
	{
		v[id].x = v[1].x*2 + v[2].x*3;
		v[id].y = v[1].y*2 + v[2].y*3;
		v[id].z = v[1].z*2 + v[2].z*3;
	}	
}

void run(int3 *v_array)
{
	int3 *gpu_v_array; 
	int size;
	
	size = sizeof(int3) * nb_threads;
	cudaMalloc((void**)&gpu_v_array, size);
	cudaMemset((void *)gpu_v_array, -1, size);

	compute<<<1, nb_threads>>>(gpu_v_array);
	
	cudaMemcpy(v_array, gpu_v_array, size, cudaMemcpyDeviceToHost);
	
	cudaFree(gpu_v_array);
}


void print_vector(int3 *v)
{
	printf("x: %d, y: %d, z: %d\n", v->x, v->y, v->z);	
}

int main(int argc, char** argv)
{
	int3 v_array[nb_threads];
	
	puts("Cude DemoSynchro -- Programmez!");
	
	init();
	run((int3*)&v_array);
	for(int i=0; i<nb_threads; i++)
		print_vector(&v_array[i]);	
	return 0;
}


