﻿using System;
using System.Threading;
using Microsoft.Ccr.Core;


namespace PostCore
{
    class Program
    {
        Port<int> lePort;
        Dispatcher leDispatcher;
        DispatcherQueue leDispatcherQueue;
        Receiver<int> leReceiver;

        Program()
        {
            lePort = new Port<int>();

            leDispatcher = new Dispatcher(2, ThreadPriority.Normal,
                DispatcherOptions.UseProcessorAffinity, "Mon Dispatcher");

            leDispatcherQueue = new DispatcherQueue("Mon DispatcherQueue", leDispatcher);
        }

        void Go()
        {

            leReceiver = Arbiter.Receive<int>(
                true,
                lePort,
                Rappel);


            Arbiter.Activate(leDispatcherQueue, leReceiver);

            for (int i = 0; i < 2; i++)
            {
                lePort.Post(i);
            }
            Console.ReadLine();
        }

        void Rappel(int valeur)
        {
            Console.WriteLine("Entrée dans le thread {0}", valeur);
            int n = 250;
            for (int i = 0; i < n; i++)
                for (int j = 0; j < n; j++)
                    for (int k = 0; k < n; k++)
                    {
                        DateTime t = DateTime.Now;
                    }
            Console.WriteLine("Sortie du thread {0}", valeur);
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Go();
        }
    }
}
