// HelloWorld.java
package com.programmez.fred.demospivot;


import java.awt.Color;  
import java.awt.Font;  

import org.apache.pivot.collections.Map;  
import org.apache.pivot.wtk.Application;  
import org.apache.pivot.wtk.DesktopApplicationContext;  
import org.apache.pivot.wtk.Display;  
import org.apache.pivot.wtk.HorizontalAlignment;  
import org.apache.pivot.wtk.Label;  
import org.apache.pivot.wtk.VerticalAlignment;  
import org.apache.pivot.wtk.Window;  

public class HelloWorld implements Application {  
	Window window;
	
    @Override 
    public void startup(Display display, Map<String, String> properties) {  
    	System.out.println("Coup d'envoi");
        Label label = new Label();  
        label.setText("Programmez!");  
        label.getStyles().put("font", new Font("Arial", Font.BOLD|Font.ITALIC, 48));  
        label.getStyles().put("color", Color.BLUE);  
        label.getStyles().put("horizontalAlignment",  
            HorizontalAlignment.CENTER);  
        label.getStyles().put("verticalAlignment",  
            VerticalAlignment.CENTER);  
        
        window = new Window();  
        window.setContent(label);  
        window.setTitle("Abonnez-vous! :-)");  
        window.setMaximized(true);
        window.open(display);

    }  

    @Override 
    public boolean shutdown(boolean optional) {  

    	System.out.println("Fin de partie");
    	
        if (window != null) {  
            window.close(); 
        } 
         
        return false;  
    }  

    @Override 
    public void suspend() {
    	System.out.println("Temps mort");
    }  

    @Override 
    public void resume() {
    	System.out.println("Reprise");
    }  

    public static void main(String[] args) {  
        DesktopApplicationContext.main(HelloWorld.class, args);  
    }  
}  
