// AllGesture.cpp : Defines the entry point for the application.
//
#include "stdafx.h"
#include "RotationGesture.h"


#include <sstream>
using namespace std;

#define MAX_LOADSTRING 100

// Global Variables:

HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_ROTATIONGESTURE, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_ROTATIONGESTURE));

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage are only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ROTATIONGESTURE));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_ROTATIONGESTURE);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HINSTANCE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

	GESTURECONFIG gc[] = {
			{
				0, // global gesture configuration flags 
				0, // aucune gesture active
				GC_ALLGESTURES, // Toutes les gestures dsactives
			},				
		};

	SetGestureConfig(
		hWnd,
		0,
		sizeof(gc)/sizeof(GESTURECONFIG),// Nb d'lments dans le tableau
		(PGESTURECONFIG)&gc, // Tableau de structures GESTURECONFIG                             
        sizeof(GESTURECONFIG) // taile d'une structure GESTURECONFIG
		);                        


   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

// Normalement, cette fonction
// n'est jamais appele dans cette application
// car seule la gesture ROTATE est active
void WriteGestureName(HWND hWnd, WCHAR* text)
{
	HDC hdc = GetDC(hWnd);
	SelectObject(hdc, GetStockObject(WHITE_PEN));
	Rectangle(hdc, 0, 0, 200, 20);
	TextOut(hdc, 0 , 0, text, lstrlen(text));
	ReleaseDC(hWnd, hdc);
}

void WriteRotation(HWND hWnd, USHORT arg)
{	
	wostringstream wss;
	wss << L"Rotation, angle: ";
	double alpha GID_ROTATE_ANGLE_FROM_ARGUMENT(arg);
	alpha = alpha*180.0/3.14159265359;
	wss << alpha;

	HDC hdc = GetDC(hWnd);
	SelectObject(hdc, GetStockObject(WHITE_PEN));
	Rectangle(hdc, 0, 0, 200, 20);
	TextOut(hdc, 0 , 0, 
		wss.str().c_str(), wss.str().length());
	ReleaseDC(hWnd, hdc);
}

LRESULT HandleGesture(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	GESTUREINFO gi;  
    ZeroMemory(&gi, sizeof(GESTUREINFO));
    gi.cbSize = sizeof(GESTUREINFO);

    BOOL result  = GetGestureInfo((HGESTUREINFO)lParam, &gi);
    BOOL done = FALSE;

    if (result){
        // Normalement seul le cas
		// GID_ROTATE peut de produire dans cette application
        switch (gi.dwID){
           case GID_ZOOM:
               WriteGestureName(hWnd, L"Zoom");     
               done = TRUE;
               break;
           case GID_PAN:
               WriteGestureName(hWnd, L"Pan");
               done = TRUE;
               break;
           case GID_ROTATE:
				WriteRotation(hWnd, (USHORT)gi.ullArguments);
               done = TRUE;
               break;
           case GID_TWOFINGERTAP:
               WriteGestureName(hWnd, L"Two Finger Tap");
               done = TRUE;
               break;
           case GID_PRESSANDTAP:
               WriteGestureName(hWnd, L"Press and Tap");
               done = TRUE;
               break;
           default:
               break;
        }
    }

    if (done)
	{
		CloseGestureInfoHandle((HGESTUREINFO)lParam);
        return 0;
    }
	else
	{
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
}



//
//  FUNCTION: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: Add any drawing code here...
		EndPaint(hWnd, &ps);
		break;
	case WM_GESTURENOTIFY:
        {

			GESTURECONFIG gc[] = {				
				{
					GID_ROTATE, // On configure la rotation 
					GC_ROTATE, // ROTATION demand
					0, // Rien n'est dsactiv sour GID_ROTATE
				},
			};

           SetGestureConfig(
                hWnd,                 
                0,                    
                sizeof(gc)/sizeof(GESTURECONFIG),// Nb d'lments dans le tableau
                (PGESTURECONFIG)&gc,                  // Tableau de structures GESTURECONFIG
                                      
                sizeof(GESTURECONFIG) // taile d'une structure GESTURECONFIG
            );                        
        }
        break;
	case WM_GESTURE:
		return HandleGesture(hWnd, message, wParam, lParam);
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
