﻿using System.Drawing;
using SlimDX;
using SlimDX.Direct3D11;

namespace Sample
{
    partial class Engine
    {
        EffectInterfaceVariable abstractMaterial;
        EffectClassInstanceVariable cSolidMaterial;
        EffectClassInstanceVariable cTextureMaterial;

        bool useSolid = true;

        public bool UseSolid
        {
            get { return useSolid; }
            set { useSolid = value; }
        }

        void CheckLinkage()
        {
            abstractMaterial = effect.GetVariableByName("abstractMaterial").AsInterface();
            cSolidMaterial = effect.GetVariableByName("cSolidMaterial").AsClassInstance();
            cTextureMaterial = effect.GetVariableByName("cTextureMaterial").AsClassInstance();

            effect.GetVariableByName("staticColor").AsVector().Set(new Color4(Color.Red));

            if (UseSolid)
                abstractMaterial.ClassInstance = cSolidMaterial;
            else
                abstractMaterial.ClassInstance = cTextureMaterial;
        }
    }
}
