﻿using System;
using System.Windows.Forms;

namespace Sample
{
    public partial class MainForm : Form
    {
        Engine engine;
        public MainForm()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            engine = new Engine(this);
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            engine.Dispose();
            engine = null;
        }

        internal void Render()
        {
            if (engine != null)
            {
                engine.ClearRender();
                engine.Render();
            }
        }

        private void radStatic_CheckedChanged(object sender, EventArgs e)
        {
            if (radStatic.Checked)
                engine.UseSolid = true;
        }

        private void radTexture_CheckedChanged(object sender, EventArgs e)
        {
            if (radTexture.Checked)
                engine.UseSolid = false;
        }
    }
}
