package ethereumjava.solidity.coder.decoder.sintdecoder;

import ethereumjava.solidity.SolidityUtils;
import ethereumjava.solidity.coder.decoder.SDecoder;
import ethereumjava.solidity.types.SInt;

/**
 * Created by gunicolas on 17/03/17.
 */

public class SInt8Decoder implements SDecoder<SInt.SInt8> {

    @Override
    public SInt.SInt8 decode(String toDecode) {
        if( !toDecode.toLowerCase().startsWith("0x") ){
            toDecode = "0x"+toDecode;
        }
        return SInt.fromByte(SolidityUtils.hexToBigDecimal(toDecode).toBigInteger().byteValue());
    }

}
