package com.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(RetentionPolicy.RUNTIME)
public @interface ExportField {
	FieldType type() default FieldType.STRING;
	
	enum FieldType {
		STRING(false),
		IMAGE(false),
		HYPERLINK(true);
		private FieldType(boolean canHaveLabel) {
			this.labelable = canHaveLabel;
		}
		private boolean labelable;
		public boolean isLabelable() {
			return labelable;
		}
		public void setLabelable(boolean labelable) {
			this.labelable = labelable;
		}
	}
}
