package com.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class FieldDescriptor {
	private Member member;
	private FieldDescriptor parent;
	private String uid = "";

	public FieldDescriptor(Class<?> masterClass, Member member, FieldDescriptor parent) {
		this.member = member;
		this.parent = parent;
		if (parent != null) {
			this.uid = parent.uid;
		} else {
			uid = masterClass.getCanonicalName();
		}
		this.uid = this.uid + "." + member.getName();
	}

	@SuppressWarnings("rawtypes")
	public Object getValueFrom(Object oThis) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		if (oThis instanceof Collection) {
			List<Object> retList = new LinkedList<Object>();
			for (Object oThisListed : (Collection) oThis) {
				retList.add(getValueFrom(oThisListed));
			}
			return retList;
		}
		Method tmpMethod = null;
		if (member instanceof Field) {
			if (((Field) member).isAccessible())
				return ((Field) member).get(oThis);
			String getterName = "get" + member.getName();
			for (Method m : member.getDeclaringClass().getMethods()) {
				if (m.getName().equalsIgnoreCase(getterName)) {
					tmpMethod = m;
					break;
				}
			}
		} else if (member instanceof Method) {
			tmpMethod = (Method) member;
		}
		if (tmpMethod != null)
			return tmpMethod.invoke(oThis);
		throw new IllegalAccessError(member.getName() + " not found in "
				+ oThis.getClass().getName());
	}

	/**
	 * @return the class member
	 */
	public Member getMember() {
		return member;
	}

	/**
	 * @return the parent field
	 */
	public FieldDescriptor getParent() {
		return parent;
	}

	/**
	 * @return the uid
	 */
	public String getUid() {
		return uid;
	}

}
