package com.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.LinkedList;
import java.util.List;

public class FieldDescriptorCollectionExportable extends
		FieldDescriptorExportable {

	private List<FieldDescriptorExportable> children;
	public FieldDescriptorCollectionExportable(Class<?> masterClass, Member field,
			FieldDescriptor parent, Annotation annotation) {
		super(masterClass, field, parent, annotation);
		children = new LinkedList<FieldDescriptorExportable>();
	}
	public void addChild(FieldDescriptorExportable child) {
		children.add(child);
	}
	@SuppressWarnings("unchecked")
	@Override
	public List<FieldCollectionValues> getValue(Object from) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		List<FieldCollectionValues> content = new LinkedList<FieldCollectionValues>();
		for(FieldDescriptorExportable child : children) {
			FieldCollectionValues values = new FieldCollectionValues();
			values.setField(child);
			values.setValues((List<Object>) child.getValue(from));
			content.add(values);
		}
		return content;
	}
	/**
	 * @return the children
	 */
	public List<FieldDescriptorExportable> getChildren() {
		return children;
	}
	/**
	 * @param children the children to set
	 */
	protected void setChildren(List<FieldDescriptorExportable> children) {
		this.children = children;
	}
}
