package com.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.annotation.ExportField.FieldType;

public class FieldDescriptorExportable extends FieldDescriptor {

	private FieldType type;

	public FieldDescriptorExportable(Class<?> masterClass, Member field,
			FieldDescriptor parent, Annotation annotation) {
		super(masterClass, field, parent);
		if (annotation instanceof ExportField) {
			type = ((ExportField) annotation).type();
		} else if (annotation instanceof ExportClassCollectionField) {
			type = FieldType.STRING;
		} else {
			throw new IllegalArgumentException(
					"Annotation must be an instance of com.keepalert.domain.annotation.ExportField or com.keepalert.domain.annotation.ExportClassCollectionField");
		}
	}

	public Object getValue(Object from) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		from = getFrom(from);
		return getValueFrom(from);
	}

	@SuppressWarnings("rawtypes")
	private Object getFrom(Object o) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		if (o instanceof Collection) {
			List<Object> retObjects = new LinkedList<Object>();
			for (Object listObject : (Collection) o) {
				retObjects.add(getFrom(listObject));
			}
			return retObjects;
		} else {
			if (getMember().getDeclaringClass().isInstance(o))
				return o;
			FieldDescriptor firstField = this;
			while (firstField.getParent() != null
					&& !firstField.getMember().getDeclaringClass()
							.isInstance(o)) {
				firstField = firstField.getParent();
			}
			if (!firstField.getMember().getDeclaringClass().isInstance(o))
				return null;
			return getFrom(firstField.getValueFrom(o));
		}
	}

	/**
	 * @return the name provided by annotation
	 */
	public String getName() {
		return getUid() + ".name";
	}

	/**
	 * @return the description provided by annotation
	 */
	public String getDescription() {
		return getUid() + ".description";
	}

	/**
	 * @return the type
	 */
	public FieldType getType() {
		return type;
	}

	public String getLabel() {
		if (!type.isLabelable())
			return "";
		return getUid()+".label";
	}

}
