package com.dataclasses;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.annotation.ExportClassCollectionField;
import com.annotation.ExportClassField;
import com.annotation.ExportField;
import com.annotation.ExportableRootClass;

public class Client implements ExportableRootClass{
	@ExportField
	private String firstName;
	@ExportField
	private String lastName;
	@ExportField
	private Address deliveryAddress;
	@ExportClassField
	private Address facturationAddress;
	@ExportClassField(className="com.dataclasses.Product")
	@ExportClassCollectionField(className="com.dataclasses.Product")
	private List<Product> products;
	@ExportField
	private int points;
	@ExportField
	public String getCompleteName() {
		return getFirstName() + " " + getLastName();
	}
	public Client() {
		deliveryAddress = new Address();
		facturationAddress = new Address();
		products = new LinkedList<Product>();
	}
	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return firstName;
	}
	/**
	 * @param firstName the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return lastName;
	}
	/**
	 * @param lastName the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	/**
	 * @return the deliveryAddress
	 */
	public Address getDeliveryAddress() {
		return deliveryAddress;
	}
	/**
	 * @param deliveryAddress the deliveryAddress to set
	 */
	public void setDeliveryAddress(Address deliveryAddress) {
		this.deliveryAddress = deliveryAddress;
	}
	/**
	 * @return the facturationAddress
	 */
	public Address getFacturationAddress() {
		return facturationAddress;
	}
	/**
	 * @param facturationAddress the facturationAddress to set
	 */
	public void setFacturationAddress(Address facturationAddress) {
		this.facturationAddress = facturationAddress;
	}
	/**
	 * @return the products
	 */
	public List<Product> getProducts() {
		return products;
	}
	/**
	 * @param products the products to set
	 */
	public void setProducts(List<Product> products) {
		this.products = products;
	}
	/**
	 * @return the points
	 */
	public int getPoints() {
		return points;
	}
	/**
	 * @param points the points to set
	 */
	public void setPoints(int points) {
		this.points = points;
	}
	@Override
	public List<String> getDefaultExportFields() {
		List<String> ret = new ArrayList<String>();
		String className = getClass().getCanonicalName() + ".";
		ret.add(className+"getCompleteName");
		ret.add(className+"points");
		ret.add(className+"products");
		ret.add(className+"products.name");
		ret.add(className+"products.reference");
		ret.add(className+"deliveryAddress");
		ret.add(className+"facturationAddress.city");
		ret.add(className+"facturationAddress.street");
		return ret;
	}
}
