package com.dataclasses;

import java.util.LinkedList;
import java.util.List;

import com.annotation.ExportClassCollectionField;
import com.annotation.ExportClassField;
import com.annotation.ExportField;

public class Product {
	@ExportField
	private String name;
	@ExportField
	private String reference;
	@ExportClassField(className="com.dataclasses.Address")
	@ExportClassCollectionField(className="com.dataclasses.Address")
	private List<Address> addressProviders;
	
	/**
	 * @return the addressProviders
	 */
	public List<Address> getAddressProviders() {
		return addressProviders;
	}
	/**
	 * @param addressProviders the addressProviders to set
	 */
	public void setAddressProviders(List<Address> addressProviders) {
		this.addressProviders = addressProviders;
	}
	public Product() {
		addressProviders = new LinkedList<Address>();
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the reference
	 */
	public String getReference() {
		return reference;
	}
	/**
	 * @param reference the reference to set
	 */
	public void setReference(String reference) {
		this.reference = reference;
	}
}
