import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import com.annotation.ExportedFieldsFinder;
import com.annotation.FieldCollectionValues;
import com.annotation.FieldDescriptorCollectionExportable;
import com.annotation.FieldDescriptorExportable;
import com.dataclasses.Address;
import com.dataclasses.Client;
import com.dataclasses.Product;

public class test {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Client client = createClient();
		ExportedFieldsFinder finder = new ExportedFieldsFinder();
		for (Class<?> clazz : finder.getKnownClasses()) {
			System.out.println("Class: " + clazz.getCanonicalName());
			for (FieldDescriptorExportable descriptor : finder.get(clazz)) {
				System.out.println("\t" + descriptor.getUid());
			}
			System.out.println("-----------------------------------");
		}
		// Print default fields
		System.out.println("Default fields");
		for (String uidField : client.getDefaultExportFields()) {
			FieldDescriptorExportable descriptor = finder.findField(uidField);
			System.out.println(uidField);
			printRow(client, descriptor);
		}
		System.out.println("-----------------------------------");
		System.out.println("All fields");
		// Print all available fields
		for (FieldDescriptorExportable descriptor : finder.get(Client.class)) {
			System.out.println(descriptor.getUid());
			printRow(client, descriptor);
		}
	}

	private static void printRow(Client client,
			FieldDescriptorExportable descriptor) {
		if (descriptor == null)
			return;
		try {
			if (descriptor instanceof FieldDescriptorCollectionExportable) {
				List<FieldCollectionValues> values = ((FieldDescriptorCollectionExportable) descriptor)
						.getValue(client);
				printCollectionValue("\t", values);
			} else {
				Object value = descriptor.getValue(client);
				if (value instanceof Iterable<?>) {
					for (Object row : (Iterable<?>) value) {
						System.out.println("\t" + row.toString());
					}
				} else {
					System.out.println("\t" + value);
				}
			}
		} catch (IllegalArgumentException | IllegalAccessException
				| InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	static void printCollectionValue(String prefix,
			List<FieldCollectionValues> values) {
		for (FieldCollectionValues coll : values) {
			System.out.println(prefix + "Special collection: "
					+ coll.getField().getUid());
			if (coll.getField() instanceof FieldDescriptorCollectionExportable) {
				List<FieldCollectionValues> innerValues = new LinkedList<FieldCollectionValues>();
				for (Object v : coll.getValues()) {
					innerValues.add((FieldCollectionValues) v);
				}
				printCollectionValue(prefix + "\t", innerValues);
			} else {
				for (Object rowVal : coll.getValues()) {
					System.out.println(prefix + "\t" + rowVal.toString());
				}
			}
		}
	}

	static Client createClient() {
		String cities[] = { "Vertesdouves", "Bassesherbes", "Vieillecour",
				"Roquedour", "Cavagne" };
		String streets[] = { "Torport", "Mont-à-loup", "Laidroit",
				"Grandepierre" };
		Client client = new Client();
		client.setFirstName("Dupont");
		client.setLastName("Francis");
		client.setPoints(100);
		client.getDeliveryAddress().setCity("Pic-à-croc");
		client.getDeliveryAddress().setZipCode("13370");
		client.getDeliveryAddress().setStreet("Malemotte");
		client.getFacturationAddress().setCity("Château-sur-sel");
		client.getFacturationAddress().setStreet("Fierchamp");
		client.getFacturationAddress().setZipCode("42420");

		Random random = new Random(System.currentTimeMillis());
		Address providers[] = new Address[5];
		for (int i = 0; i < providers.length; ++i) {
			providers[i] = new Address();
			providers[i].setCity(cities[random.nextInt(cities.length - 1)]);
			providers[i].setStreet(streets[random.nextInt(streets.length - 1)]);
			providers[i].setZipCode(String.valueOf(random.nextInt(99999)));
		}

		for (int i = 0; i < 3; ++i) {
			Product product = new Product();
			product.setName("Product num. " + String.valueOf(i));
			product.setReference("#" + String.valueOf(random.nextInt(10000)));
			client.getProducts().add(product);
			int iterations = random.nextInt(5);
			for (int j = 0; j < iterations; ++j) {
				product.getAddressProviders().add(
						providers[random.nextInt(providers.length - 1)]);
			}
		}
		return client;
	}
}
