#include "FirebirdUtils.hpp"

#include <vector>
#include <cstdlib>

using namespace std;

// Edition de lien  la sauce Microsoft.
#pragma comment(lib, "fbclient_ms.lib")

const string database = "c:\\FirebirdEmbedded\\employee.fdb";
const string programmez_database = "C:\\FirebirdEmbedded\\programmez.fdb";

const char* requetes[] =
{
	"CREATE TABLE Equipe (Nom varchar(20) NOT NULL "
	"Primary Key, Prenom varchar(20), Salaire integer)",

	"INSERT INTO Equipe (Nom, Prenom, Salaire)"
	"VALUES ('Kaminsky', 'Jean', 10000)",

	"INSERT INTO Equipe (Nom, Prenom, Salaire)"
	"VALUES ('Tonic', 'Francois', 1000)",

	"INSERT INTO Equipe (Nom, Prenom, Salaire)"
	"VALUES ('Develay', 'Sebastien', 100)",

	"INSERT INTO Equipe (Nom, Prenom)"
	"VALUES ('Mazue', 'Frederic')",

	"SELECT * FROM Equipe",
};

void TestConnexion()
{
	FbConnection cn(database, "SYSDBA", "masterkey");
	cout << "Test Connexion: ok" << endl; 
}

void TestQuery()
{
	FbConnection cn(programmez_database, "SYSDBA", "masterkey");
	FbTransaction trans(cn);

	trans.executeSQLQuery(requetes[5]);
	auto_ptr<vector<string> > v = trans.getResultQuery();

	for(vector<string>::iterator i= v->begin(),
		end = v->end(); i!=end; ++i)
	{
		cout << *i << endl;
	}

	cout << "Test query: ok" << endl;	
}

void TestCreateTable(FbConnection& cn)
{
	FbTransaction tr(cn);
	tr.executeSQL(requetes[0]);
	cout << "Test CreateTable: ok" << endl;
}

void TestInsertData(FbConnection& cn)
{
	vector<string> req(requetes+1, requetes+5);

	FbTransaction trans(cn);


	for(vector<string>::const_iterator i=req.begin(),
		end = req.end(); i!=end; ++i)
	{
		trans.executeSQL(*i);
	}
	cout << "Test InsertData: ok" << endl;
}

void TestCreateDatabase()
{
	FbConnection cn(programmez_database, "SYSDBA", "masterkey", true);
	TestCreateTable(cn);
	TestInsertData(cn);
	cout << "Test CreateBase: ok" << endl;
}


int main()
{
	remove(programmez_database.c_str());
	try
	{
		TestConnexion();
		TestCreateDatabase();
		TestQuery();
		cout << endl;
	}
	catch(FbException fbe)
	{
		fbe.print();
	}
	catch(bad_alloc)
	{
		cout << "Votre systeme semble epuise" << endl;
	}
	cin.get();
}