#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <stdlib.h>

int main(void)
{
    printf("Exemple d'utilisation de la fonction fork()\n");
    pid_t pid;          /* Déclaration de la variable pid qui recevra l'ID du processus enfant */
    pid = fork();       /* Duplication du processus en cours dans le but de créer un processus enfant*/

    if ( pid == -1 )
    {
        fprintf(stderr,
                "%s: Une erreur s'est produite avec fork()\n",
                strerror(errno));
        exit(13);
    }
    else if ( pid == 0 ) /* pid est à zéro dans le cas de l'exécution du processus enfant !*/
    {
        sleep(1);   /* On attend un moment */

        printf("PID %ld: Je suis le processus enfant, l'ID de mon parent est %ld.\n",
               (long)getpid(),     /* PID actuel enfant*/
               (long)getppid());   /* PID du parent*/

        pid_t pidpe;          /* Déclaration de la variable pid qui recevra l'ID du processus 'petit-enfant' */
        pidpe = fork();       /* Duplication du processus en cours dans le but de créer un processus enfant de l'enfant*/

        if ( pidpe == -1 )
        {
            fprintf(stderr,
                    "%s: Une erreur s'est produite avec fork()\n",
                    strerror(errno));
            exit(13);
        }
        else if ( pidpe == 0 ) /* pid est à zéro dans le cas de l'exécution du processus petit-enfant !*/
        {
            sleep(2);   /* On attend un moment */
            printf("PID %ld: Je suis le processus petit enfant, l'ID de mon parent est %ld.\n",
                   (long)getpid(),     /* PID actuel du petit enfant*/
                   (long)getppid());   /* PID du parent*/

        }

    }
    else
    {
        printf("PID %ld: Je suis le processus parent, l'ID de mon enfant est %ld.\n",
               (long)getpid(),     /* PID actuel du parent */
               (long)pid);         /* PID de l'enfant*/
    }
    sleep(4);   /* On attend un moment */

   return 0;
}
