#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <stdlib.h>
#include <sys/wait.h>

int main(void)
{
    printf("Exemple d'utilisation de la fonction fork() avec wait()\n");
    pid_t pid;          /* Déclaration de la variable pid qui recevra l'ID du processus enfant */
    pid = fork();       /* Duplication du processus en cours dans le but de créer un processus enfant*/
    pid_t pid2;         /* ID du processus retourné par wait() */

    if ( pid == -1 )
    {
        fprintf(stderr,
                "%s: Une erreur s'est produite avec fork()\n",
                strerror(errno));
        exit(13);
    }
    else if ( pid == 0 ) /* pid est à zéro dans le cas de l'exécution du processus enfant !*/
    {
        printf("PID %ld: Je suis le processus enfant, l'ID de mon parent est %ld.\n",
               (long)getpid(),     /* PID actuel enfant*/
               (long)getppid());   /* PID du parent*/
        pid = fork();       /* Duplication du processus en cours dans le but de créer un processus enfant de l'enfant*/
        pid2 = waitpid(pid,NULL,0);

        if ( pid == -1 )
        {
            fprintf(stderr,
                    "%s: Une erreur s'est produite avec fork()\n",
                    strerror(errno));
            exit(13);
        }
        else if ( pid== 0 ) /* pid est à zéro dans le cas de l'exécution du processus petit-enfant !*/
        {
            sleep(2);
            printf("PID %ld: Je suis le processus petit enfant, l'ID de mon parent est %ld.\n",
                   (long)getpid(),     /* PID actuel du petit enfant*/
                   (long)getppid());   /* PID du parent*/

        }
    }
    else
    {
        pid2 = waitpid(pid,NULL,0);
        printf("PID %ld: Je suis le processus parent, l'ID de mon enfant est %ld.\n",
               (long)getpid(),     /* PID actuel du parent */
               (long)pid);         /* PID de l'enfant*/

    }

    return 0;
}
