#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>

#define RUNNING_DIR	"/tmp"
#define LOCK_FILE	"demonfork.lock"
#define LOG_FILE	"demonfork.log"
#define F_TLOCK 2

void log_message(filename,message)
char *filename;
char *message;
{
    FILE *logfile;
    logfile=fopen(filename,"a");
    if (!logfile) return;
    fprintf(logfile,"%s\n",message);
    fclose(logfile);
}

void signal_handler(sig)
int sig;
{
    switch (sig)
    {
    case SIGHUP:
        log_message(LOG_FILE,"Signal hangup intercepté",sig);
        break;
    case SIGTERM:
        log_message(LOG_FILE,"Signal terminate intercepté",sig);
        exit(0);
        break;
    }
}

void daemonize()
{
    int i,lfp;
    char str[10];
    if (getppid()==1) return; /* Suis-je déjà un daemon ? Oui : retour*/
    i=fork();
    if (i<0) exit(1); /* erreur lors du fork*/
    if (i>0) exit(0); /* je me détache du parent*/
    /* Je suis l'enfant futur daemon */
    setsid(); /* je fais partie d'un nouveau groupe de processus */
    for (i=getdtablesize();i>=0;--i) close(i); /* je ferme tous les descripteurs*/
    i=open("/dev/null",O_RDWR);
    dup(i);
    dup(i);
    umask(027); /* Nouvelle permission et nouveau répertoire d'exécution */
    chdir(RUNNING_DIR);
    lfp=open(LOCK_FILE,O_RDWR|O_CREAT,0640);
    if (lfp<0) exit(1); /* je ne peux ouvrir le fichier qui contiendra mon PID*/
    if (lockf(lfp,F_TLOCK,0)<0) exit(0);
    sprintf(str,"%d\n",getpid());
    write(lfp,str,strlen(str)); /* j'écris mon PID dans le fichier */
    signal(SIGCHLD,SIG_IGN); /* j'ignore certains signaux */
    signal(SIGTSTP,SIG_IGN);
    signal(SIGTTOU,SIG_IGN);
    signal(SIGTTIN,SIG_IGN);
    signal(SIGHUP,signal_handler); /* par contre j'intercepte  */
    signal(SIGTERM,signal_handler); /* les signaux hangup et kill */
}

int main(void)
{
    daemonize();
    while (1) sleep(1); /* Itérative principale : je suis un daemon */
    return(0);
}
