// on cree ici le GestureDetector et on le retourne
private GestureDetector createGestureDetector(Context context) {

    GestureDetector gestureDetector = new GestureDetector(context);

    // on cree un listener de gestes generiques
    gestureDetector.setBaseListener(new GestureDetector.BaseListener() {

        @Override
        public boolean onGesture(Gesture gesture) {
            if (gesture == Gesture.TAP) {
                // l utilisateur a tape sur la branche avec un doigt
                return true;
            } else if (gesture == Gesture.TWO_TAP) {
                // l utilisateur a tape avec deux doigts
                return true;
            } else if (gesture == Gesture.THREE_TAP) {
                // l utilisateur a tape avec trois doigts
                return true;
            } else if (gesture == Gesture.SWIPE_RIGHT) {
                // l utilisateur a fait glisser son doigt vers la droite
                return true;
            } else if (gesture == Gesture.SWIPE_LEFT) {
                // l utilisateur a fait glisse son doigt vers la gauche
                return true;
            } else if (gesture == Gesture.SWIPE_DOWN) {
                // l utilisateur a fait glisse son doigt vers le bas
                return true;
            } else if (gesture == Gesture.SWIPE_UP) {
                // l utilisateur a fait glisse son doigt vers le haut
                return true;
            }
            return false;
        }

    });

    // on cree un listener sur les doigts touchant la branche tactile
    gestureDetector.setFingerListener(new GestureDetector.FingerListener() {

        @Override
        public void onFingerCountChanged(int previousCount, int currentCount) {
          // on entre ici lorsque le nombre de doigts sur la branche change
        }

    });

    // on cree un listener lorsqu un glissement est effectue sur la branche tactile
    gestureDetector.setScrollListener(new GestureDetector.ScrollListener() {

        @Override
        public boolean onScroll(float displacement, float delta, float velocity) {
            // on entre ici lorsque l on fait glisser un ou plusieurs doigts sur la branche
            return false;
        }

    });
    return gestureDetector;
}