
var failure = function(data, res) { res.json(500, {error:data}); }

function restoreClientSession(req) {
    client = new OAuth2Client(
        "CLIENT_ID",
        "CLIENT_SECRET",
        "http://localhost:8084/glass/oauth2callback");
    if (req.session && req.session.client && req.session.client.credentials)
        client.credentials = req.session.client.credentials;
    return client;
}

function checkLogged(req, res) {

    if (!req.session ||
        !req.session.client ||
        !req.session.client.credentials) {
        var url = restoreClientSession(req).generateAuthUrl({
            access_type: 'offline',
            scope: 'https://www.googleapis.com/auth/glass.timeline'
        });
        res.redirect(url);
        res.end();
    }
}

var grabToken = function (code, req, res){
    req.session.client = restoreClientSession(req);
    req.session.client.getToken(code, function(err, tokens){
        if (!!err)
            failure(err, res);
        else {
            req.session.client.credentials = tokens;
            res.redirect('/glass');
        }
    });
};

app.get('/glass/oauth2callback', function(req, res){
    grabToken(req.query.code, req, res);
});

app.get('/glass', function(req,res){
    checkLogged(req, res);
    res.json(200, {ok: "ok"})
});