/***********
 Application dependencies
 ***********/

var express = require('express'),
    http = require('http'),
    path = require('path'),
    fs = require('fs'),
    googleapis = require('googleapis'),
    request = require('request'),
    parseString = require('xml2js').parseString,
    Iconv  = require('iconv').Iconv,
    moment  = require('moment'),
    OAuth2Client = googleapis.OAuth2Client;

var app = express();
app.use(express.cookieParser());
app.use(express.session({secret: 'myGlassSecretPass'}));
app.set('port', 8084);
app.use(express.favicon());
app.use(express.logger('dev'));
app.use(express.bodyParser());
app.use(express.methodOverride());
app.use(app.router);

app.use(express.static(path.join(__dirname, 'public/')));

/***********
 Application Run
 ***********/

http.createServer(app).listen(app.get('port'), function(){
    console.log('Express server listening on port ' + app.get('port'));
});
