/***********
 Application dependencies
 ***********/

var express = require('express'),
    http = require('http'),
    path = require('path'),
    fs = require('fs'),
    googleapis = require('googleapis'),
    request = require('request'),
    parseString = require('xml2js').parseString,
    Iconv  = require('iconv').Iconv,
    moment  = require('moment'),
    OAuth2Client = googleapis.OAuth2Client;

var app = express();
app.use(express.cookieParser());
app.use(express.session({secret: 'myGlassSecretPass'}));
app.set('port', 8084);
app.use(express.favicon());
app.use(express.logger('dev'));
app.use(express.bodyParser());
app.use(express.methodOverride());
app.use(app.router);

app.use(express.static(path.join(__dirname, 'public/')));

var link = "http://localhost:8084/glass/oauth2callback";

var users = [];

function restoreClientSession(req) {
    client = new OAuth2Client(
        "CLIENT_ID",
        "CLIENT_SECRET",
        link);
    if (req.session && req.session.client && req.session.client.credentials)
        client.credentials = req.session.client.credentials;
    return client;
}

var success = function(data, res) { res.send(data); };
var failure = function(data, res) { res.json(500, {error:data}); }

var gotToken = function (fptr, req, res, param) {
    if (!checkToken(req, res))
        return;
    googleapis
        .discover('mirror', 'v1')
        .execute(function(err, client) {
            if (!!err)
                failure();
            else
                fptr(client, req, res, param);
        });
};

var grabToken = function (code, req, res){
    req.session.client = restoreClientSession(req);
    req.session.client.getToken(code, function(err, tokens){
        if (!!err)
            failure(err, res);
        else {
            req.session.client.credentials = tokens;
            res.redirect('/glass');
        }
    });
};

function checkLogged(req, res) {

    if (!req.session ||
        !req.session.client ||
        !req.session.client.credentials) {
        var url = restoreClientSession(req).generateAuthUrl({
            access_type: 'offline',
            scope: 'https://www.googleapis.com/auth/glass.timeline'
        });
        res.redirect(url);
        res.end();
    }
}

function checkToken(req, res) {

    if (!req.session ||
        !req.session.client ||
        !req.session.client.credentials) {
        failure("error", res);
        res.end();
        return false;
    }
    return true;
}

/*
 API Calls
 */

var deleteCart = function(client, req, res, param){
    client
        .mirror.timeline.delete({"id": param})
        .withAuthClient(restoreClientSession(req))
        .execute(function(err, data){
            if (!!err)
                failure(err);
            else
                success(data, res);
        });
};

var insertCard = function(client, req, res, param){
    request.get('http://www.programmez.com/rss/rss_actu_redir.php', {encoding: null}, function (error, response, body) {

        if (!error && response && response.statusCode == 200) {
            var iconv = new Iconv('ISO-8859-1', 'UTF-8');
            body = iconv.convert(body);

            parseString(body, function (err, result) {
                var articles = result.rss.channel[0].item;
                var article = articles[Math.floor(Math.random() * articles.length)];

                moment.lang('en');
                var date = moment(article.pubDate[0]);
                moment.lang('fr');
                date = date.format("dddd Do MMMM YYYY, h:mm:ss a");

                client
                    .mirror.timeline.insert({"html": "<article>\
                    <section><div class=\"text-auto-size\">\
                    <img style='padding:5px; background:#fff;' src='http://programmez.com/img/logo.jpg'/><p>"+(article.title)+"</p>\
                    </div></section>\
                    <footer><div>"+date+"</div></footer>\
                    </article>",
                        "notification": {
                            "level": "DEFAULT"
                        },
                        "menuItems": [{"action":"OPEN_URI", payload: article.link}, {"action": "SHARE"}, {"action": "DELETE"}]})
                    .withAuthClient(restoreClientSession(req))
                    .execute(function(err, data){
                        if (!!err)
                            failure(err, res);
                        else
                            success(data, res);
                    });
            });
        }
    });
};

var registerNotif = function(client, req, res, param) {
    client.credentials = req.session.client.credentials;
    for (var i = 0; i < users.length; i++) {
        if (users[i].client.credentials.access_token == client.credentials.access_token) {
            res.json(500, {"ko":"ko"});
            return ;
        }
    }
    users.push({"client":client, "req":req});
    res.json(200, {"ok":"ok"});
};

var unregisterNotif = function(client, req, res, param) {
    for (var i = 0; i < users.length; i++) {
        if (users[i].client.credentials.access_token == client.credentials.access_token) {
            users.splice(i, 1);
            res.json(200, {"ok":"ok"});
            return ;
        }
    }
    res.json(500, {"ko":"ko"});
};

var listTimeline = function(client, req, res, param){
    client
        .mirror.timeline.list()
        .withAuthClient(restoreClientSession(req))
        .execute(function(err, data){
            if (!!err)
                failure(err, res);
            else
                success(data, res);
        });
};

/***********
 Application Auth
 ***********/

app.get('/glass', function(req,res){
    checkLogged(req, res);
    fs.readFile(path.join(__dirname, 'public/index.html'), 'utf8', function (err,data) {
        res.send(data);
    });

});

app.get('/glass/oauth2callback', function(req, res){
    grabToken(req.query.code, req, res);
});

/***********
 Application Actions
 ***********/


app.get('/glass/timeline', function(req, res) {
    checkLogged(req, res);
    gotToken(listTimeline, req, res);
});

app.get('/glass/card', function(req, res) {
    checkLogged(req, res);
    gotToken(insertCard, req, res);
});

app.get('/glass/register', function(req, res) {
    checkLogged(req, res);
    gotToken(registerNotif, req, res);
});

app.get('/glass/unregister', function(req, res) {
    checkLogged(req, res);
    gotToken(unregisterNotif, req, res);
});

app.get('/glass/deletecard/:id', function(req, res) {
    var id = req.params.id;
    checkLogged(req, res);
    gotToken(deleteCart, req, res, id);
});

/***********
 Application Run
 ***********/

setInterval(function() {
    request.get('http://www.programmez.com/rss/rss_actu_redir.php', {encoding: null}, function (error, response, body) {
        var iconv = new Iconv('ISO-8859-1', 'UTF-8');
        body = iconv.convert(body);

        if (!error && response && response.statusCode == 200) {
            parseString(body, function (err, result) {
                var articles = result.rss.channel[0].item;
                var article = articles[Math.floor(Math.random() * articles.length)];

                moment.lang('en');
                var date = moment(article.pubDate[0]);
                moment.lang('fr');
                date = date.format("dddd Do MMMM YYYY, h:mm:ss a");

                for (var i = 0; i < users.length; i++) {
                    users[i].client
                        .mirror.timeline.insert({"html": "<article>\
                    <section><div class=\"text-auto-size\">\
                    <img style='padding:5px; background:#fff;' src='http://programmez.com/img/logo.jpg'/><p>"+(article.title)+"</p>\
                    </div></section>\
                    <footer><div>"+date+"</div></footer>\
                    </article>",
                            "notification": {
                                "level": "DEFAULT"
                            },
                            "menuItems": [{"action":"OPEN_URI", payload: article.link}, {"action": "SHARE"}, {"action": "DELETE"}]})
                        .withAuthClient(restoreClientSession(users[i].req))
                        .execute(function(err, data){
                            if (!!err)
                                users.splice(i, 1);
                        });
                }
            });
        }
    });
}, 15000 );

http.createServer(app).listen(app.get('port'), function(){
    console.log('Express server listening on port ' + app.get('port'));
});
