package com.programmez.android.map;

import java.util.ArrayList;
import java.util.List;

import android.graphics.drawable.Drawable;
import android.os.Bundle;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;

public class ProgrammezMapActivity extends MapActivity {

	private MapView mapView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		initMapView();
		// goToParis();
		addMyLocation();
		drawGreenRobots();
	}

	private void initMapView() {
		mapView = (MapView) findViewById(R.id.mapview);
		mapView.setBuiltInZoomControls(true);
	}

	private void goToParis() {
		GeoPoint parisPoint = new GeoPoint(48856668, 2350988);
		mapView.getController().animateTo(parisPoint);
		mapView.getController().setZoom(12);
	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	private void addMyLocation() {
		final MyLocationOverlay myLocationOverlay = new MyLocationOverlay(this,
				mapView);
		mapView.getOverlays().add(myLocationOverlay);
		myLocationOverlay.enableMyLocation();
		myLocationOverlay.runOnFirstFix(new Runnable() {
			public void run() {
				mapView.getController().animateTo(
						myLocationOverlay.getMyLocation());
				mapView.getController().setZoom(16);
			}
		});
	}

	private void drawGreenRobots() {
		Drawable androidmarker = this.getResources().getDrawable(
				R.drawable.androidmarker);
		RobotsOverlay robotsOverlay = new RobotsOverlay(androidmarker);
		List<GeoPoint> robots = lookForRobots();
		for (GeoPoint geoPoint : robots) {
			robotsOverlay.addRobot(geoPoint);
		}
		mapView.getOverlays().add(robotsOverlay);
	}

	private List<GeoPoint> lookForRobots() {
		ArrayList<GeoPoint> robotLocations = new ArrayList<GeoPoint>();
		robotLocations.add(new GeoPoint(48866465, 2301400));
		robotLocations.add(new GeoPoint(48872887, 2298481));
		robotLocations.add(new GeoPoint(48867100, 2294383));
		return robotLocations;
	}
}