package com.programmez.android.map;

import java.util.ArrayList;

import android.graphics.drawable.Drawable;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.ItemizedOverlay;
import com.google.android.maps.OverlayItem;

public class RobotsOverlay extends ItemizedOverlay {

	ArrayList<OverlayItem> overlayList = new ArrayList<OverlayItem>();

	public RobotsOverlay(Drawable defaultMarker) {
		super(boundCenterBottom(defaultMarker));
	}

	@Override
	protected OverlayItem createItem(int i) {
		return overlayList.get(i);
	}

	@Override
	public int size() {
		return overlayList.size();
	}

	public void addRobot(GeoPoint geoPoint) {
		overlayList.add(new OverlayItem(geoPoint, "", ""));
		populate();
	}

}
