package com.icauda.article.programmez.guava;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class CacheMain {

	private Integer ageDeSophie;
	private Map<String, Integer> ages;

	private LoadingCache<String, Integer> ageCache = CacheBuilder.newBuilder()//
			.maximumSize(2000)//
			.expireAfterWrite(30, TimeUnit.MINUTES)//
			.build(new CacheLoader<String, Integer>() {
				public Integer load(String prenom) {
					return 5;
				}
			});

	public Integer getAge(String prenom) {
		try {
			return ageCache.get(prenom);
		} catch (ExecutionException e) {
			return -1;
		}

	}

	private Supplier<Integer> ageDeSophieCache = Suppliers.memoizeWithExpiration(//
			new Supplier<Integer>() {
				public Integer get() {
					return 5;
				}
			}, 12, TimeUnit.HOURS);

	public Integer getAgeDeSophie() {
		return ageDeSophieCache.get();
	}

}
