package com.icauda.article.programmez.guava;

import static java.math.RoundingMode.HALF_DOWN;
import static java.math.RoundingMode.HALF_EVEN;

import java.math.RoundingMode;

import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;

public class CalculMain {
	public static void main(String[] args) {

		int n1 = Integer.MAX_VALUE; // 2147483647
		int n2 = n1 + 10; // -2147483639

		System.out.println(n1);
		System.out.println(n2);

		// int n3 = IntMath.checkedAdd(n1, 10); // ArithmeticException: overflow

		int puis = IntMath.pow(2, 5); // 32
		int log10_5 = IntMath.log10(5, HALF_DOWN); // 1
		int log2_5 = IntMath.log2(5, HALF_EVEN); // 2
		double log2_7 = DoubleMath.log2(7); // 2.807354922057604
		// int racine5 = IntMath.sqrt(5, UNNECESSARY); // ArithmeticException:
		// mode was UNNECESSARY, but rounding was necessary
		int racine5b = IntMath.sqrt(5, RoundingMode.FLOOR); // 2
		boolean isInt = DoubleMath.isMathematicalInteger(racine5b); // true

		System.out.println(puis);
		System.out.println(log10_5);
		System.out.println(log2_5);
		System.out.println(log2_7);
		// System.out.println(racine5);
		System.out.println(isInt);

		int pgcd = IntMath.gcd(6, 15); // 3
		int factoriel = IntMath.factorial(5); // 120
		int coefBinomial = IntMath.binomial(5, 3); // 10

		System.out.println(pgcd);
		System.out.println(factoriel);
		System.out.println(coefBinomial);

	}
}
