package com.icauda.article.programmez.guava;

public enum Genre {
	FEMME("F"), HOMME("H");

	private final String code;

	Genre(final String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public static Genre valueOfByCode(final String code) {
		for (Genre genre : values()) {
			if (genre.code.equals(code)) {
				return genre;
			}
		}
		throw new UnsupportedOperationException("Code non supporte");
	}

}
