package com.icauda.article.programmez.guava;

import java.util.List;

import com.google.common.collect.Lists;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;

public class HashMain {

	public static void main(String[] args) {

		// Personne personne = new Personne("Sophie", "Dupont", Genre.FEMME);
		//
		// HashFunction hf = Hashing.md5();
		// HashCode hc = hf.newHasher()//
		// .putDouble(personne.getPoids())//
		// .putString(personne.getNom())//
		// .putString(personne.getPrenom())//
		// .hash();
		// byte[] bytes = hc.asBytes();

		Funnel<Personne> funnel = new Funnel<Personne>() {
			@Override
			public void funnel(Personne personne, PrimitiveSink sink) {
				sink.putDouble(personne.getPoids())//
						.putString(personne.getNom())//
						.putString(personne.getPrenom());
			}
		};

		int NB = 6558585;// 7;
		List<Personne> habitants = Lists.newArrayListWithCapacity(NB);
		BloomFilter<Personne> bloom = BloomFilter.create(funnel, NB, 0.01);

		for (int i = 0; i < NB; i++) {
			Personne p = new Personne("a" + i, "b");
			habitants.add(p);
			bloom.put(p);
		}

		Personne sophie = new Personne("Sophie", "Dupont", Genre.FEMME);
		long avant = System.currentTimeMillis();
		boolean isIn = habitants.contains(sophie);
		long apres = System.currentTimeMillis();
		long duree = apres - avant;
		System.out.println(duree);

		boolean maybeIn = bloom.mightContain(sophie);

	}
}
