package com.icauda.article.programmez.guava;

import static com.google.common.base.Charsets.ISO_8859_1;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;

public class IOMain {

	public static boolean copie(String original, String destination) {
		boolean ok = false;
		File f1 = new File(original);
		File f2 = new File(destination);

		FileInputStream fis = null;
		FileOutputStream fos = null;

		try {
			fis = new FileInputStream(f1);
			fos = new FileOutputStream(f2);
			byte buffer[] = new byte[512 * 1024];
			int nblecture;
			while ((nblecture = fis.read(buffer)) != -1) {
				fos.write(buffer, 0, nblecture);
			}
			ok = true;
		} catch (FileNotFoundException e) {
			// ...
		} catch (IOException e) {
			// ...
		} finally {
			try {
				fis.close();
			} catch (Exception e) {
				// ...
			}
			try {
				fos.close();
			} catch (Exception e) {
				// ...
			}
		}
		return ok;
	}

	public static boolean copie2(String original, String destination) {
		boolean ok = false;
		File f1 = new File(original);
		File f2 = new File(destination);

		FileInputStream fis = null;
		FileOutputStream fos = null;

		try {
			fis = new FileInputStream(f1);
			fos = new FileOutputStream(f2);

			ByteStreams.copy(fis, fos);
			ok = true;
		} catch (FileNotFoundException e) {
			// ...
		} catch (IOException e) {
			// ...
		} finally {
			try {
				Closeables.close(fis, !ok);
			} catch (IOException e) {
				// ...
			}
			try {
				Closeables.close(fos, !ok);
			} catch (IOException e) {
				// ...
			}
		}
		return ok;
	}

	public static boolean copie3(String original, String destination) {
		boolean ok = false;
		File f1 = new File(original);
		File f2 = new File(destination);

		try {
			ByteStreams.copy(Files.newInputStreamSupplier(f1), Files.newOutputStreamSupplier(f2));
			ok = true;
		} catch (IOException e) {
		}
		return ok;
	}

	public static String lire(String original) {
		File f = new File(original);
		String s = null;
		try {
			s = CharStreams.toString(Files.newReaderSupplier(f, Charsets.ISO_8859_1));
		} catch (IOException e) {
			// ...
		}
		return s;
	}

	public static String lire2(String original) {
		File f = new File(original);
		String s = null;
		try {
			s = Files.toString(f, Charsets.ISO_8859_1);
		} catch (IOException e) {
			// ...
		}
		return s;
	}

	public static List<String> lireEtTraiterLignes(String original) {
		File f = new File(original);

		final LineProcessor<List<String>> lp = new LineProcessor<List<String>>() {
			ImmutableList.Builder<String> builder = ImmutableList.builder();

			@Override
			public List<String> getResult() {
				return builder.build();
			}

			@Override
			public boolean processLine(String line) throws IOException {
				if (!line.startsWith("#")) {
					builder.add(line);
				}
				return true;
			}
		};
		List<String> lines = null;
		try {
			lines = Files.readLines(f, ISO_8859_1, lp);
		} catch (IOException e) {
			// ...
		}
		return lines;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("io main");
	}

}
