package com.icauda.article.programmez.guava;

import static com.icauda.article.programmez.guava.Genre.FEMME;
import static com.icauda.article.programmez.guava.Genre.HOMME;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public class JoinerMain {

	public static String listToString(List<String> liste) {

		if (liste == null) {
			throw new IllegalArgumentException("Liste nulle");
		}

		final StringBuilder sb = new StringBuilder();

		boolean premier = true;
		for (String item : liste) {
			if (item == null) {
				continue;
			}
			if (premier) {
				premier = false;
			} else {
				sb.append(", ");
			}
			sb.append(item);
		}

		return sb.toString();
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// "Anne Dupond, Bernard Lavache, Cline Martini, Jean Duval, Lon Loup, Thierry Leriche, Vincent Duval";

		final List<Personne> personnes = Lists.newArrayList(//
				new Personne("Anne", "Dupond", FEMME), //
				new Personne("Bernard", "Lavache", HOMME), //
				new Personne("Cline", "Martini", FEMME), //
				new Personne("Hing", "Chan", HOMME), //
				new Personne("Lon", "Loup", HOMME), //
				new Personne("Thierry", "Leriche", HOMME), //
				new Personne("Vincent", "Duval", HOMME));

		String s = Joiner.on(", ")//
				.appendTo(new StringBuilder(), Iterables.transform(personnes, //
						new Function<Personne, String>() {
							public String apply(Personne personne) {
								return personne.getPrenom();
							}
						})).toString();
		System.out.println(s);
	}

}
