package com.icauda.article.programmez.guava;

import static com.google.common.base.CharMatcher.DIGIT;
import static com.google.common.base.CharMatcher.JAVA_UPPER_CASE;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;

public class MatcherMain {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("matcher");

		String sansChiffre = CharMatcher.DIGIT.removeFrom("AB12cd34"); // ABcd
		String sansLettre = CharMatcher.JAVA_LETTER.removeFrom("AB12cd34"); // 1234
		String sansAscii = CharMatcher.ASCII.removeFrom("AB12cd34"); // vide

		System.out.println(sansChiffre);
		System.out.println(sansLettre);
		System.out.println(sansAscii);

		String sansChiffreMaj = DIGIT.or(JAVA_UPPER_CASE).removeFrom("AB12cd34"); // cd
		System.out.println(sansChiffreMaj);

		int nb = DIGIT.countIn("AB12cd34"); // 4
		String collapse = DIGIT.collapseFrom("AB12cd34", '*'); // AB*cd*
		String replace = DIGIT.replaceFrom("AB12cd34", "-+"); // AB-+-+cd-+-+
		int index = DIGIT.indexIn("AB12cd34"); // 2

		System.out.println(nb);
		System.out.println(collapse);
		System.out.println(replace);
		System.out.println(index);

		String s = "AB12cd34";
		try {
			byte[] bytes = s.getBytes("UFT-8"); // UnsupportedEncodingException:
												// UFT-8
			System.out.println(bytes);
		} catch (Exception e) {
			// traitement
			e.printStackTrace();
		}

		byte[] bytes = s.getBytes(Charsets.UTF_16BE); // [B@882c01f
		System.out.println(bytes);

	}

}
