package com.icauda.article.programmez.guava;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

public class MultimapMain {
	public static void main(String[] args) {
		System.out.println("main");

		Map<Personne, List<String>> map = new HashMap<Personne, List<String>>();
		Personne paul = new Personne("Paul", "Dupont");
		addAchat(paul, "tshirt", map);
		addAchat(paul, "pull", map);

		Multimap<Personne, String> multimap = HashMultimap.create();
		multimap.put(paul, "tshirt");
		multimap.put(paul, "pull");
	}

	public static void addAchat(Personne client, String produit, Map<Personne, List<String>> map) {

		List<String> produits = map.get(client);
		if (produits == null) {
			produits = new ArrayList<String>();
			map.put(client, produits);
		}
		produits.add(produit);
	}
}
