package com.icauda.article.programmez.guava;

import java.util.Date;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;

public class Personne implements Comparable<Personne> {

	private Integer id;
	private String prenom;
	private String nom;
	private Date naissance;
	private Genre genre;
	private Double poids;

	public Personne(final String prenom, final String nom) {
		// if (prenom == null) {
		// throw new
		// NullPointerException("Le parametre prenom ne peut pas etre null.");
		// }
		// this.prenom = prenom;

		this.prenom = Preconditions.checkNotNull(prenom, "Le parametre prenom ne peut pas etre null.");
		// if (nom == null) {
		// throw new
		// NullPointerException("Le parametre nom ne peut pas etre null.");
		// }
		// this.nom = nom;
		this.nom = Preconditions.checkNotNull(nom, "Le parametre nom ne peut pas etre null.");
	}

	public Personne(final String prenom, final String nom, final Genre genre) {
		this(prenom, nom);

		if (genre == null) {
			throw new NullPointerException("Le parametre genre ne peut pas etre null.");
		}
		this.genre = genre;
	}

	public Personne(final String prenom, final String nom, final Date naissance) {
		this(prenom, nom);

		if (naissance == null) {
			throw new NullPointerException("Le parametre naissance ne peut pas etre null.");
		}
		if (new Date().after(naissance)) {
			throw new IllegalArgumentException("Le parametre naissance ne peut pas etre dans le futur.");
		}
		this.naissance = naissance;
	}

	// Getters et setters

	@Override
	public int hashCode() {
		// final int prime = 31;
		// int result = 1;
		// result = prime * result + ((naissance == null) ? 0 :
		// naissance.hashCode());
		// result = prime * result + ((nom == null) ? 0 : nom.hashCode());
		// result = prime * result + ((prenom == null) ? 0 : prenom.hashCode());
		// return result;
		return Objects.hashCode(naissance, nom, prenom);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Personne other = (Personne) obj;
		// if (naissance == null) {
		// if (other.naissance != null)
		// return false;
		// } else if (!naissance.equals(other.naissance))
		// return false;
		// if (nom == null) {
		// if (other.nom != null)
		// return false;
		// } else if (!nom.equals(other.nom))
		// return false;
		// if (prenom == null) {
		// if (other.prenom != null)
		// return false;
		// } else if (!prenom.equals(other.prenom))
		// return false;
		// return true;
		return Objects.equal(naissance, other.naissance) //
				&& Objects.equal(nom, other.nom) //
				&& Objects.equal(prenom, other.prenom);
	}

	@Override
	public String toString() {
		// StringBuilder builder = new StringBuilder();
		// builder.append("Personne [prenom=");
		// builder.append(prenom);
		// builder.append(", nom=");
		// builder.append(nom);
		// builder.append(", genre=");
		// builder.append(genre);
		// builder.append("]");
		// return builder.toString();

		return Objects.toStringHelper("Personne")//
				.add("prenom", prenom)//
				.add("nom", nom)//
				.add("genre", genre)//
				.toString();
	}

	@Override
	public int compareTo(Personne other) {
		// int result = prenom.compareTo(other.prenom);
		// if (result != 0) {
		// return result;
		// }
		// result = nom.compareTo(other.nom);
		// if (result != 0) {
		// return result;
		// }
		// result = naissance.compareTo(other.naissance);
		// return result;

		return ComparisonChain.start()//
				.compare(prenom, other.prenom)//
				.compare(nom, other.nom)//
				.compare(naissance, other.naissance)//
				.result();

	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getPrenom() {
		return prenom;
	}

	public void setPrenom(String prenom) {
		this.prenom = prenom;
	}

	public String getNom() {
		return nom;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

	public Date getNaissance() {
		return naissance;
	}

	public void setNaissance(Date naissance) {
		this.naissance = naissance;
	}

	public Genre getGenre() {
		return genre;
	}

	public void setGenre(Genre genre) {
		this.genre = genre;
	}

	public Double getPoids() {
		return poids;
	}

	public void setPoids(Double poids) {
		Preconditions.checkArgument(0 < poids, "Le poids doit etre positif mais %s est negatif.", poids);
		this.poids = poids;
	}

}
