package com.icauda.article.programmez.guava;

import static com.google.common.base.Predicates.and;
import static com.google.common.base.Predicates.in;
import static com.icauda.article.programmez.guava.Genre.FEMME;
import static com.icauda.article.programmez.guava.Genre.HOMME;

import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

public class ProgFoncMain {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		final List<Personne> personnes = Lists.newArrayList(//
				new Personne("Anne", "Dupond", FEMME), //
				new Personne("Bernard", "Lavache", HOMME), //
				new Personne("Cline", "Martini", FEMME), //
				new Personne("Hing", "Chan", HOMME), //
				new Personne("Lon", "Loup", HOMME), //
				new Personne("Thierry", "Leriche", HOMME), //
				new Personne("Vincent", "Duval", HOMME));

		Predicate<Personne> malePredicate = new Predicate<Personne>() {
			@Override
			public boolean apply(Personne personne) {
				return personne.getGenre() == HOMME;
			}
		};

		Personne homme = Iterables.find(personnes, malePredicate);
		Personne homme2 = Iterables.find(personnes, malePredicate, new Personne("sans", "nom"));

		// Iterable<Personne> hommes = Iterables.filter(personnes,
		// malePredicate);

		Function<Personne, String> nameFunction = new Function<Personne, String>() {
			@Override
			public String apply(Personne personne) {
				return personne.getPrenom() + " " + personne.getNom();
			}
		};
		// List<Personne> hommes = newArrayList(filter(personnes,
		// malePredicate));
		// List<String> names = Lists.transform(personnes, nameFunction);

		List<String> names = FluentIterable.from(personnes) //
				.filter(malePredicate) //
				.transform(nameFunction)//
				.toImmutableList();

		final Set<Personne> clients = Sets.newHashSet(new Personne("Bernard", "Lavache", HOMME), //
				new Personne("Lon", "Loup", HOMME), //
				new Personne("Thierry", "Leriche", HOMME));

		boolean inBothColl = and(in(personnes), in(clients)).apply(new Personne("Lon", "Loup", HOMME));

	}

}
