package com.icauda.article.programmez.guava;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Lists.newArrayListWithCapacity;
import static com.google.common.collect.Lists.newArrayListWithExpectedSize;

import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;

public class StaticFactoryMain {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// List<String> arcEnCiel = new ArrayList<String>();
		// Map<String, String> codesCouleur = new HashMap<String, String>();

		List<String> arcEnCiel = newArrayList("rouge", "orange", "jaune", "vert", "bleu", "indigo", "violet");

		List<String> cielEnArc = Lists.reverse(arcEnCiel);

		List<List<String>> pagination = Lists.partition(arcEnCiel, 5);
		System.out.println(pagination.get(0));
		System.out.println(pagination.get(1));

		// arcEnCiel.add("rouge");
		// arcEnCiel.add("orange");
		// arcEnCiel.add("jaune");
		// arcEnCiel.add("vert");
		// arcEnCiel.add("bleu");
		// arcEnCiel.add("indigo");
		// arcEnCiel.add("violet");

		Map<String, String> codesCouleur = new ImmutableMap.Builder<String, String>() //
				.put("rouge", "#FF0000")//
				.put("orange", "#FFA500")//
				.put("jaune", "#FFFF00").put("vert", "#00FF00").put("bleu", "#0000FF").put("indigo", "#4B0082").put("violet", "#800080")

				.build();

		// ImmutableMap.of(, , , ,
		// "#0000FF", "indigo", "#4B0082", "violet", "#800080");

		List<String> couleurs = newArrayListWithCapacity(50);
		List<String> couleurs2 = newArrayListWithExpectedSize(50);

	}

}
