package com.icauda.article.programmez.guava;

import static com.icauda.article.programmez.guava.Genre.FEMME;
import static com.icauda.article.programmez.guava.Genre.HOMME;

import java.util.Map;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

public class TableMain {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Table<Integer, Genre, Personne> table = HashBasedTable.create();
		table.put(21, FEMME, new Personne("Sophie", "Martini"));
		table.put(28, FEMME, new Personne("Virginie", "Papatis"));
		table.put(35, FEMME, new Personne("Alice", "Bihan"));
		table.put(21, HOMME, new Personne("John", "Labiro"));
		table.put(25, HOMME, new Personne("Julien", "Pong"));
		table.put(35, HOMME, new Personne("Adrien", "Pactola"));
		table.put(36, HOMME, new Personne("Thierry", "Leriche"));

		Personne alice = table.get(35, FEMME);

		Map<Integer, Personne> byColomn = table.column(FEMME); // Alice, Sophie,
																// Virginie
		System.out.println(byColomn);
		Map<Genre, Personne> byLine = table.row(35); // Alice, Adrien
		System.out.println(byLine);

	}

}
