package com.icauda.article.programmez.guava;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

public class UnionMain {
	public static void main(String[] args) {
		System.out.println("main");

		Set<String> set1 = ImmutableSet.of("rouge", "bleu", "noir", "jaune");
		Set<String> set2 = ImmutableSet.of("vert", "indigo", "blanc", "jaune", "orange");

		Set<String> union = Sets.union(set1, set2);
		System.out.println(union);

		Set<String> inter = Sets.intersection(set1, set2);
		Set<String> diff = Sets.difference(set1, set2);

		Map<String, Integer> map1 = ImmutableMap.<String, Integer> builder()//
				.put("Julie", 25)//
				.put("Marc", 34)//
				.put("John", 17)//
				.build();
		Map<String, Integer> map2 = ImmutableMap.<String, Integer> builder()//
				.put("Thierry", 45)//
				.put("Marc", 34)//
				.put("John", 17)//
				.put("Arnaud", 13)//
				.build();

		MapDifference<String, Integer> mapdiff = Maps.difference(map1, map2);
		// not equal: only on left={Julie=25}: only on right={Thierry=45,
		// Arnaud=13}
		Map<String, Integer> mapinter = mapdiff.entriesInCommon(); // {John=17,
																	// Marc=34}
		System.out.println(mapdiff);
		System.out.println(mapinter);
	}
}
