//
//  ITViewController.m
//  CoreMotionExample
//
//  Created by Vincent Saluzzo on 07/10/13.
//  Copyright (c) 2013 Itelios. All rights reserved.
//

#import "ITViewController.h"

@import CoreMotion;

@interface ITViewController ()

@property (nonatomic, strong) CMStepCounter* stepCounter;
@property (nonatomic, assign) long stepCount;


@property (nonatomic, strong) CMMotionActivityManager* motionActivityManager;
@property (nonatomic, strong) NSString* currentMotionState;
@end

@implementation ITViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    
    // Initialize properties
    self.stepCount = 0;
    
    
    // Initialize Step Counter
    if([CMStepCounter isStepCountingAvailable]) {
        self.stepCounter = [[CMStepCounter alloc] init];
        [self.stepCounter startStepCountingUpdatesToQueue:[NSOperationQueue currentQueue]
                                                 updateOn:1
                                              withHandler:
         ^(NSInteger numberOfSteps, NSDate *timestamp, NSError *error) {
             self.stepCount += numberOfSteps;
             [self reloadStepCounterUI];
         }];
    } else {
        [[[UIAlertView alloc] initWithTitle:@"Impossible d'acceder au StepCounter" message:@"Il semblerai que le StepCounter soit innacessible sur votre iPhone." delegate:nil cancelButtonTitle:@"D'accord" otherButtonTitles:nil] show];
    }
    
    // Initialize Activity Manager
    if([CMMotionActivityManager isActivityAvailable]) {
        self.motionActivityManager = [[CMMotionActivityManager alloc] init];
        [self.motionActivityManager startActivityUpdatesToQueue:[NSOperationQueue currentQueue]
                                                    withHandler:
         ^(CMMotionActivity *activity) {
             if(activity.stationary) {
                 self.currentMotionState = @"à l'arret";
             } else if(activity.walking) {
                 self.currentMotionState = @"en balade";
             } else if(activity.running) {
                 self.currentMotionState = @"en course";
             } else if(activity.automotive) {
                 self.currentMotionState = @"en véhicule";
             } else {
                 self.currentMotionState = @"... ?";
             }
             [self reloadActivityStateUI];
         }];
    } else {
        [[[UIAlertView alloc] initWithTitle:@"Impossible d'acceder à l'Activityanager" message:@"Il semblerai que l'ActivityManager soit innacessible sur votre iPhone." delegate:nil cancelButtonTitle:@"D'accord" otherButtonTitles:nil] show];
    }
    
    // (re)Load UI
    [self reloadStepCounterUI];
    [self reloadActivityStateUI];
}

-(void) reloadStepCounterUI {
    if([CMStepCounter isStepCountingAvailable]) {
        self.stepCountLabel.text = [NSString stringWithFormat:@"%ld", self.stepCount];
    } else {
        self.stepCountLabel.text = @"<undefined>";
    }
}

-(void) reloadActivityStateUI {
    if([CMMotionActivityManager isActivityAvailable]) {
        self.motionStateLabel.text = self.currentMotionState;
    } else {
        self.motionStateLabel.text = @"<undefined>";
    }
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
