//
//  ITAppDelegate.m
//  NewMultitaskModeDemo
//
//  Created by Vincent Saluzzo on 11/10/13.
//  Copyright (c) 2013 Itelios. All rights reserved.
//

#import "ITAppDelegate.h"

@implementation ITAppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    // Override point for customization after application launch.
    [application setMinimumBackgroundFetchInterval:UIApplicationBackgroundFetchIntervalMinimum];
    return YES;
}


-(void) application:(UIApplication *)application performFetchWithCompletionHandler:(void (^)(UIBackgroundFetchResult))completionHandler {
    NSLog(@"Demarrage du Background Fetch");
    
    NSURLRequest* request = [NSURLRequest requestWithURL:[NSURL URLWithString:@"http://192.168.2.112:1337"]];
    
    [NSURLConnection sendAsynchronousRequest:request queue:[NSOperationQueue mainQueue] completionHandler:^(NSURLResponse *response, NSData *data, NSError *connectionError) {
        NSString* str = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
        UILocalNotification* notif = [[UILocalNotification alloc] init];
        notif.alertBody = str;
        notif.alertAction = @"Resultat";
        notif.fireDate = [[NSDate date] dateByAddingTimeInterval:3];
        [application scheduleLocalNotification:notif];
        NSLog(@"Fin du Background Fetch");
        completionHandler(UIBackgroundFetchResultNewData);
    }];
}
							
- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later. 
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end
