//
//  ITSyntaxHighlightTextStorage.m
//  TextKitDemo
//
//  Created by Vincent Saluzzo on 09/10/13.
//  Copyright (c) 2013 Itelios. All rights reserved.
//

#import "ITSyntaxHighlightTextStorage.h"

@implementation ITSyntaxHighlightTextStorage
{
    NSMutableAttributedString* _persistence;
}

- (id)init
{
    self = [super init];
    if (self) {
        _persistence = [[NSMutableAttributedString alloc] init];
    }
    return self;
}


-(NSString*) string {
    return [_persistence string];
}

-(NSDictionary*) attributesAtIndex:(NSUInteger)location effectiveRange:(NSRangePointer)range {
    return [_persistence attributesAtIndex:location effectiveRange:range];
}

-(void) replaceCharactersInRange:(NSRange)range withString:(NSString *)str {
    [self beginEditing];
    [_persistence replaceCharactersInRange:range withString:str];
    [self edited:NSTextStorageEditedCharacters|NSTextStorageEditedAttributes range:range changeInLength:str.length-range.length];
    [self endEditing];
}

-(void) setAttributes:(NSDictionary *)attrs range:(NSRange)range {
    [self beginEditing];
    [_persistence setAttributes:attrs range:range];
    [self edited:NSTextStorageEditedAttributes range:range changeInLength:0];
    [self endEditing];
}


-(void) processEditing {
    [self performReplacement:[self editedRange]];
    [super processEditing];
}

-(void) performReplacement:(NSRange)changedRange {
    NSRange realStartLineRange = [[_persistence string] lineRangeForRange:NSMakeRange(changedRange.location, 0)];
    NSRange extendedRange = NSUnionRange(changedRange, realStartLineRange);
    
    NSRange realEndLineRange = [[_persistence string] lineRangeForRange:NSMakeRange(NSMaxRange(changedRange), 0)];
    
    extendedRange = NSUnionRange(changedRange, realEndLineRange);
    
    [self applyStyles:extendedRange];
}

-(void) applyStyles:(NSRange)searchRange {
    
    NSArray* colors = @[[UIColor redColor], [UIColor blueColor], [UIColor orangeColor]];
    NSArray* regexes = @[@"1", @"2", @"3"];

    for (NSString* aRegEx in regexes) {
        NSRegularExpression* regex = [NSRegularExpression regularExpressionWithPattern:aRegEx options:9 error:nil];
        UIColor* color = (UIColor*) colors[[regexes indexOfObject:aRegEx]];
        
        [regex enumerateMatchesInString:[_persistence string] options:0 range:searchRange usingBlock:^(NSTextCheckingResult *result, NSMatchingFlags flags, BOOL *stop) {
            NSRange matchRange = [result rangeAtIndex:0];
            [self addAttributes:@{NSForegroundColorAttributeName : color} range:matchRange];
            
            if (NSMaxRange(matchRange)+1 < self.length) {
                [self addAttributes:@{ NSForegroundColorAttributeName : [UIColor blackColor] } range:NSMakeRange(NSMaxRange(matchRange)+1, 1)];
            }
        }];
    }
}

@end
