//
//  ITViewController.m
//  TextKitDemo
//
//  Created by Vincent Saluzzo on 08/10/13.
//  Copyright (c) 2013 Itelios. All rights reserved.
//

#import "ITViewController.h"
#import "ITSyntaxHighlightTextStorage.h"

@interface ITViewController ()

@end

@implementation ITViewController {
    ITSyntaxHighlightTextStorage* _textStorage;
    UITextView* _textView;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    [self createTextView];
    
    _textView.delegate = self;
    _textView.font = [UIFont preferredFontForTextStyle:UIFontTextStyleBody];
}

-(void) viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    _textView.frame = self.view.bounds;
}

-(void) createTextView {
    NSDictionary* attrs = @{NSFontAttributeName: [UIFont preferredFontForTextStyle:UIFontTextStyleBody]};
    NSAttributedString* attrString = [[NSAttributedString alloc] initWithString:@"" attributes:attrs];
    
    _textStorage = [[ITSyntaxHighlightTextStorage alloc] init];
    [_textStorage appendAttributedString:attrString];
    
    
    CGRect newTextViewRect = self.view.bounds;
    
    
    
    NSLayoutManager* layoutManager = [[NSLayoutManager alloc] init];
    
    
    
    CGSize containerSize = CGSizeMake(newTextViewRect.size.width, CGFLOAT_MAX);
    NSTextContainer* container = [[NSTextContainer alloc] initWithSize:containerSize];
    container.widthTracksTextView = YES;
    
    
    container.exclusionPaths = @[[UIBezierPath bezierPathWithOvalInRect:CGRectMake(60, 100, 200, 100)]];
    
    [layoutManager addTextContainer:container];
    [_textStorage addLayoutManager:layoutManager];
    
    
    
    _textView = [[UITextView alloc] initWithFrame:newTextViewRect textContainer:container];
    
    _textView.delegate = self;
    [self.view addSubview:_textView];
    
    _textView.textAlignment = NSTextAlignmentJustified;
    _textView.text = @"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin id lorem eget nunc ornare volutpat. Proin nisi lacus, auctor ac fringilla nec, vestibulum eu risus. Etiam purus odio, tincidunt in lorem id, aliquet blandit urna. Vivamus eu accumsan dolor. Vivamus ullamcorper laoreet molestie. Integer in urna ac neque iaculis consequat. Donec dapibus risus at sapien porttitor sodales eu eget ante. Maecenas vel risus enim. Fusce in odio et erat pulvinar posuere. Praesent facilisis auctor dolor, in gravida lacus suscipit tempus. Vivamus ligula nunc, laoreet eu consequat in, sagittis a tellus. Aliquam dignissim diam nec tellus cursus, at feugiat nunc scelerisque.";
    
    
    UIButton* button = [[UIButton alloc] initWithFrame:CGRectMake(60, 115, 200, 90)];
    [button setTitle:@"Je suis un bouton placé en plein milieu du texte !" forState:UIControlStateNormal];
    [button setBackgroundColor:[UIColor orangeColor]];
    [button setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont boldSystemFontOfSize:20];
    button.titleLabel.numberOfLines = 0;
    button.titleLabel.adjustsFontSizeToFitWidth = YES;
    button.titleLabel.textAlignment = NSTextAlignmentCenter;
    button.layer.cornerRadius = 45;
    [self.view addSubview:button];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
