//
//  ITViewController.m
//  UIKitDynamicsExample
//
//  Created by Vincent Saluzzo on 07/10/13.
//  Copyright (c) 2013 Itelios. All rights reserved.
//

#import "ITViewController.h"

@interface ITViewController ()

@end

@implementation ITViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	
    _animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    
    _gravity = [[UIGravityBehavior alloc] initWithItems:@[self.aButton]];
    _gravity.magnitude = 0.1;
    
    _collision = [[UICollisionBehavior alloc] initWithItems:@[self.aButton, self.aLabel]];
    _collision.translatesReferenceBoundsIntoBoundary = YES;
    _collision.collisionDelegate = self;
    _collision.collisionMode = UICollisionBehaviorModeEverything;
    
    _snap = [[UISnapBehavior alloc] initWithItem:self.aLabel snapToPoint:CGPointMake(200, 400)];
    
    _push = [[UIPushBehavior alloc] initWithItems:@[self.aLabel] mode:UIPushBehaviorModeInstantaneous];
    _push.active = NO;
    _push.pushDirection = CGVectorMake(10, -10);
    
    _attachment = [[UIAttachmentBehavior alloc] initWithItem:self.aButton attachedToAnchor:CGPointMake(160, 100)];
    _attachment.length = 300.0;

    
    
    [_animator addBehavior:_collision];
    [_animator addBehavior:_gravity];
//    [_animator addBehavior:_snap];
//    [_animator addBehavior:_push];
//    [_animator addBehavior:_attachment];
    
    [self.aButton addTarget:self action:@selector(tapOnButton:) forControlEvents:UIControlEventTouchUpInside];
}

-(void) collisionBehavior:(UICollisionBehavior*)behavior beganContactForItem:(id<UIDynamicItem>)item1 withItem:(id<UIDynamicItem>)item2 atPoint:(CGPoint)p {
    NSLog(@"A collision was detected on item %@ and item %@ at point %@", item1, item2, NSStringFromCGPoint(p));
}

-(void) tapOnButton:(id)sender {
    _push.active = YES;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
