/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.agent.SpringPlugin;

public class GlobalConfiguration {
    private static Logger log;
    public static final boolean fieldRewriting = true;
    public static boolean catchersOn;
    public static boolean fileSystemMonitoring;
    public static boolean logging;
    public static boolean verboseMode;
    public static boolean isRuntimeLogging;
    public static boolean callsideRewritingOn;
    public static boolean cleanCache;
    public static boolean isCaching;
    public static String profile;
    public static String cacheDir;
    public static final boolean logNonInterceptedReflectiveCalls = false;
    public static final boolean assertsOn = false;
    public static final boolean isProfiling = false;
    public static boolean directlyDefineTypes;
    public static final boolean interceptReflection = true;
    public static boolean reloadMessages;
    public static boolean verifyReloads;
    public static String dumpFolder;
    public static Properties globalConfigurationProperties;
    public static List<String> classesToDump;
    public static int maxClassDefinitions;
    public static List<String> pluginClassnameList;
    public static final boolean debugplugins;

    static {
        boolean debugPlugins;
        block43: {
            log = Logger.getLogger(GlobalConfiguration.class.getName());
            catchersOn = true;
            fileSystemMonitoring = false;
            logging = false;
            verboseMode = false;
            isRuntimeLogging = false;
            callsideRewritingOn = true;
            cleanCache = false;
            isCaching = false;
            profile = null;
            cacheDir = null;
            directlyDefineTypes = true;
            reloadMessages = false;
            verifyReloads = true;
            dumpFolder = null;
            maxClassDefinitions = 100;
            globalConfigurationProperties = new Properties();
            debugPlugins = false;
            try {
                String userhome;
                boolean specifiedCaching = false;
                String value = System.getProperty("springloaded");
                if (isRuntimeLogging && log.isLoggable(Level.FINEST)) {
                    log.finest("GlobalConfiguration: being configured from '" + value + "'");
                }
                if (value != null) {
                    StringTokenizer st = new StringTokenizer(value, ";");
                    while (st.hasMoreTokens()) {
                        String kv = st.nextToken();
                        int equals = kv.indexOf(61);
                        if (equals == -1) continue;
                        String key = kv.substring(0, equals);
                        if (key.equals("dump")) {
                            String classList = kv.substring(equals + 1);
                            StringTokenizer clSt = new StringTokenizer(classList, ",");
                            classesToDump = new ArrayList<String>();
                            while (clSt.hasMoreTokens()) {
                                classesToDump.add(clSt.nextToken().replace('.', '/'));
                            }
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: dumping: " + classesToDump);
                            continue;
                        }
                        if (key.equals("cleanCache")) {
                            cleanCache = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("caching")) {
                            specifiedCaching = true;
                            isCaching = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("debugplugins")) {
                            debugPlugins = true;
                            continue;
                        }
                        if (key.equals("profile")) {
                            profile = kv.substring(equals + 1);
                            continue;
                        }
                        if (key.equals("cacheDir")) {
                            cacheDir = kv.substring(equals + 1);
                            continue;
                        }
                        if (key.equals("callsideRewritingOn")) {
                            callsideRewritingOn = kv.substring(equals + 1).equalsIgnoreCase("true");
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: callsideRewritingOn = " + callsideRewritingOn);
                            continue;
                        }
                        if (key.equals("verifyReloads")) {
                            verifyReloads = kv.substring(equals + 1).equalsIgnoreCase("true");
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: verifyReloads = " + verifyReloads);
                            continue;
                        }
                        if (key.equals("dumpFolder")) {
                            dumpFolder = kv.substring(equals + 1);
                            if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                            log.info("configuration: dumpFolder = " + dumpFolder);
                            continue;
                        }
                        if (key.equals("maxClassDefinitions")) {
                            try {
                                maxClassDefinitions = Integer.parseInt(kv.substring(equals + 1));
                                if (!isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                                log.info("configuration: maxClassDefinitions = " + maxClassDefinitions);
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("ERROR: unable to parse " + kv.substring(equals + 1) + " as a integer");
                            }
                            continue;
                        }
                        if (key.equals("logging")) {
                            isRuntimeLogging = kv.substring(equals + 1).equalsIgnoreCase("true");
                            logging = kv.substring(equals + 1).equalsIgnoreCase("true");
                            System.out.println("Spring-Loaded logging = (" + isRuntimeLogging + "," + logging + ")");
                            continue;
                        }
                        if (key.equals("verbose")) {
                            reloadMessages = verboseMode = kv.substring(equals + 1).equalsIgnoreCase("true");
                            continue;
                        }
                        if (key.equals("rebasePaths")) {
                            globalConfigurationProperties.put("rebasePaths", kv.substring(equals + 1));
                            continue;
                        }
                        if (key.equals("inclusions")) {
                            globalConfigurationProperties.put("inclusions", kv.substring(equals + 1));
                            continue;
                        }
                        if (key.equals("exclusions")) {
                            globalConfigurationProperties.put("exclusions", kv.substring(equals + 1));
                            continue;
                        }
                        if (!key.equals("plugins")) continue;
                        String pluginList = kv.substring(equals + 1);
                        StringTokenizer pluginListTokenizer = new StringTokenizer(pluginList, ",");
                        pluginClassnameList = new ArrayList<String>();
                        while (pluginListTokenizer.hasMoreTokens()) {
                            pluginClassnameList.add(pluginListTokenizer.nextToken());
                        }
                    }
                }
                if (profile != null) {
                    if (profile.equals("grails")) {
                        if (cacheDir == null) {
                            try {
                                userhome = System.getProperty("user.home");
                                if (userhome != null) {
                                    cacheDir = userhome + File.separator + ".grails";
                                    new File(cacheDir).mkdir();
                                }
                            }
                            catch (Throwable t) {
                                System.err.println("looks like user.home is not set, or cannot write to it: cannot create cache.");
                                t.printStackTrace(System.err);
                            }
                        }
                        if (!specifiedCaching && cacheDir != null) {
                            isCaching = true;
                        }
                        if (pluginClassnameList == null) {
                            pluginClassnameList = new ArrayList<String>();
                        }
                        pluginClassnameList.add("org.springsource.loaded.SystemPropertyConfiguredIsReloadableTypePlugin");
                        SpringPlugin.support305 = false;
                    }
                } else if (isCaching) {
                    try {
                        userhome = System.getProperty("user.home");
                        if (userhome != null) {
                            cacheDir = userhome;
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("looks like user.home is not set: cannot create cache.");
                        t.printStackTrace(System.err);
                    }
                }
                if (!isCaching) break block43;
                try {
                    File cacheDirFile = new File(cacheDir);
                    if (!cacheDirFile.exists()) {
                        boolean created = cacheDirFile.mkdirs();
                        if (!created) {
                            System.err.println("Caching deactivated: failed to create cache directory: " + cacheDir);
                            isCaching = false;
                        }
                    } else if (!cacheDirFile.isDirectory()) {
                        System.err.println("Caching deactivated: unable to use specified cache area, it is not a directory: " + cacheDirFile);
                        isCaching = false;
                    }
                }
                catch (Exception e) {
                    System.err.println("Unexpected problem creating specified cachedir: " + cacheDir);
                    e.printStackTrace();
                }
            }
            catch (Throwable t) {
                System.err.println("Unexpected problem reading global configuration setting:" + t.toString());
                t.printStackTrace();
            }
        }
        debugplugins = debugPlugins;
    }
}

