package com.java_javafx_programmez_article_java8;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Locale;

/**
 *
 * @author Kaesar ALNIJRES
 */
public class ParisTimeZoneTest {
    public static void main(String[] args) {
                
        ZoneId  zone=ZoneId.of("Europe/Paris");
              
        for(int i=0;i<10;i++)
        {
        int an=2013+i;
        ZonedDateTime zdate=ZonedDateTime.of(LocalDateTime.of(an,10,1,1,1), zone);
        ZoneRules rules=zone.getRules();
       
         //Heure été
         ZoneOffsetTransition transition=rules.previousTransition(Instant.from(zdate));
         LocalDateTime d=LocalDateTime.ofInstant(transition.getInstant(), zone);
         
            System.out.println("Année "+an);
         
         System.out.printf("%-14s le %s %d %s %d%n",
                "Heure d'été",
                d.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.FRENCH),
                d.getDayOfMonth(),
                d.getMonth().getDisplayName(TextStyle.FULL, Locale.FRENCH),
                d.getYear());
        
        
        
        transition=rules.nextTransition(Instant.from(zdate));
         d=LocalDateTime.ofInstant(transition.getInstant(), zone);
         
         System.out.printf("%-14s le %s %d %s %d%n",
                "Heure d'hiver",
                d.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.FRENCH),
                d.getDayOfMonth(),
                d.getMonth().getDisplayName(TextStyle.FULL, Locale.FRENCH),
                d.getYear());
         
         
        
         
            System.out.println("==========================================================");
         
               
        }
        
        
    }
}
