'use strict';

// Contrôleur utilisé pour afficher un chemin sur une carte
angular.module('mean.application').controller('TrackMapController', ['$scope', '$http', '$stateParams', 'TrackService', 'leafletData',
  function($scope, $http, $stateParams, TrackService, leafletData) {
    
    $scope.center = {
      lat: 0,
      lng: 0,
      zoom: 5,
      autoDiscover: true
    };
    $scope.defaults = {
        zoomControlPosition: 'topleft',
        scrollWheelZoom: true
    };
    $scope.layers = { 
        baselayers: [{
          name: 'OpenStreetMap',
          type: 'xyz',
          url: 'http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
          layerOptions: {
              subdomains: ['a', 'b', 'c'],
              attribution: '© OpenStreetMap contributors',
              continuousWorld: true
          }
        },
        {
            name: 'OpenCycleMap',
            type: 'xyz',
            url: 'http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png',
            layerOptions: {
                subdomains: ['a', 'b', 'c'],
                attribution: '© OpenCycleMap contributors - © OpenStreetMap contributors',
                continuousWorld: true
            }
        }]
    };
    // Données chargées de façon aynchrone
    $scope.geoJSON = {};
    $scope.markers = {};

    //Récupère un chemin via son ID
    $scope.findOne = function() {
      TrackService.get({
        trackId: $stateParams.trackId
      }, function(track) {
        $scope.track = track;
        // Récupération des données au format GeoJSON
        $http.get('/api/track.GeoJSON/' + track._id).success(function(data, status) {
            angular.extend($scope, {
                geoJSON: {
                    data: data,
                    style: {
                        weight: 5,
                        color: 'red'
                    }
                }
            });
            // Initialisation de la position
            $scope.markers.you = {
              lat: track.waypoints[1],
              lng: track.waypoints[0],
              message: "You are here"
            };
        });
        leafletData.getMap().then(function(map) {
          // Zoom sur le chemin
          map.fitBounds( [ [track.bbox[1], track.bbox[0]], [track.bbox[3], track.bbox[2]] ] );
        });
      });
    };
  }
]);
