'use strict';

var mongoose = require('mongoose'),
  Track = mongoose.model('Track'),
  _ = require('lodash');

module.exports = {
    // Middleware qui récupère le chemin via son ID et le stocke pour les middleware suivants
    findById: function(req, res, next, id) {
        Track.getById(id, function(err, track) {
            if (err) return next(err);
            if (!track) return next(new Error('Failed to load track ' + id + ' : ' + err.message ));
            req.track = track;
            next();
        });
    },
    // Créé un nouveau chemin
    create: function(req, res) {
        var track = new Track(req.body);
        track.user = req.user;
        
        track.save(function(err) {
            if (err) {
              return res.status(500).json({ error: 'Cannot save the track : ' + err.message });
            }

            res.json(track);
        });
    },
    // Met à jour un chemin existant
    update: function(req, res) {
        var track = req.track;
        track = _.extend(track, req.body);
        track.save(function(err) {
            if (err) {
                return res.status(500).json({ error: 'Cannot update the track : ' + err.message });
            }

            res.json(track);
        });
    },
    // Détruit un chemin existant
    destroy: function(req, res) {
        var track = req.track;

        track.remove(function(err) {
            if (err) {
                return res.status(500).json({ error: 'Cannot delete the track : ' + err.message });
            }
            res.json(track);
        });
    },
    // Récupère un chemin via son ID
    get: function(req, res) {
        res.json(req.track);
    },
    // Récupère un chemin en GeoJSON via son ID
    getGeoJSON: function(req, res) {
        res.json(req.track.geojson);
    },
    // Liste les chemins existants pour l'utilisateur
    list: function(req, res) {
        Track.find({user: req.user}).sort('-created').populate('user', 'name username').exec(function(err, tracks) {
            if (err) {
                return res.status(500).json({ error: 'Cannot list the tracks : ' + err.message });
            }
            res.json(tracks);
        });
    },
    count: function (req, res) {
        Track.count().exec(function (err, count) {
            if (err) {
                return res.status(500).json({ error: 'Cannot count the tracks : ' + err.message });
            }
            res.json({count: count});
        });
    }
};

