using System;
using System.Net.Mail;
using System.Net.Mime;

namespace SendMail
{
    class Program
    {
        static void Main(string[] args)
        {
            string archive = "c:\\temp\\mondoc.doc.gz";
            string attachment_name = "mondoc.doc.gz"; 

            MailAddress from = new MailAddress(
                "frederic.mazue@wanadoo.fr", "Frdric Mazu");
            MailAddress to = new MailAddress(
                "fmazue@programmez.com", "FMazue");
            MailMessage msg = new MailMessage(from, to);
            msg.Subject = "Sauvegarde d'une archive";
            msg.Body = "Cette archive contient,.. etc, etc";

            Attachment attach = new Attachment(
                archive, MediaTypeNames.Application.Octet);

            ContentDisposition dispo = attach.ContentDisposition;
            dispo.FileName = attachment_name;
            dispo.CreationDate = System.IO.File.GetCreationTime(archive);
            dispo.ModificationDate = System.IO.File.GetLastWriteTime(archive);
            dispo.ReadDate = System.IO.File.GetLastAccessTime(archive);
    
            msg.Attachments.Add(attach);

            SmtpClient cl = new SmtpClient();
            cl.UseDefaultCredentials = true;
            cl.Host = "smtp.wanadoo.fr";
            try
            {
                cl.Send(msg);
                Console.WriteLine("Envoi du mail reussi");
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
    }
}
